import ExpiringMixin from 'web-client/models/core/mixins/instance/expiring';
import LoadWithProfileMixin from 'web-client/models/core/mixins/instance/load-with-profile';
import LoadingMixin from 'web-client/models/core/mixins/instance/loading';
import LoadingCollectionMixin from 'web-client/models/core/mixins/instance/loading-collection';
import CachedMixin from 'web-client/models/core/mixins/static/cached';
import ArrayProxy from 'ember-controller/proxy';

/**
 * Base class constructed by resource mixins to represent collections of models
 * @class
 */
let CollectionModel = ArrayProxy.extend(
  LoadingMixin,
  LoadingCollectionMixin,
  ExpiringMixin,
  LoadWithProfileMixin,
  LoadingCollectionMixin, {});
CollectionModel.reopenClass(CachedMixin, {});

export default CollectionModel;
