import Mixin from 'ember-metal/mixin';
import Ember from 'ember';
import KrakenListSerializer from 'web-client/models/core/serializers/kraken-list-serializer';
import computed from 'ember-computed';

const { Object: EmberObject, Evented, on } = Ember;

export default Mixin.create(Evented, {
  _initializeContent: on('init', function () {
    this.set('content', []);
  }),

  /** Configuration */

  model: EmberObject,
  serializer: KrakenListSerializer.create(),

  /** Publicly exposed properties and methods */

  itemSerializer: computed(function () {
    return (this.get('model')._create()).get('serializer');
  })
});
