/* globals _ */

import Mixin from 'ember-metal/mixin';

export default Mixin.create({

  save(hash) {
    if (this.get('isSaving')) {
      return;
    }
    this.set('isSaving', true);
    return this.apiSave(hash).then((data) => {
      _.each(data, (value, key) => {
        this.set(key, value);
      });
      this.trigger('saveSuccess', data);
      return data;
    }).finally(() => {
      this.set('isSaving', false);
    });
  }

});
