import Mixin from 'ember-metal/mixin';
import { getOwnerInjection } from 'web-client/utilities/owner-injection';

export default Mixin.create({

  /*
   * Return an object that is passed to `create(` as properties for an
   * instantiated factory that supports `Ember.inject.service`.
   */
  _ownerInjection() {
    let ownerInjection = getOwnerInjection();
    if (ownerInjection) {
      return ownerInjection;
    }

    /*
     * If there is no application running (expected only in tests), allow
     * the factory to be created without supporting injections. To do this
     * in way comaptible with `create(`, return an object.
     */
    return {};
  }
});
