import EmberObject from 'ember-object';
import ExpiringMixin from 'web-client/models/core/mixins/instance/expiring';
import LoadWithProfileMixin from 'web-client/models/core/mixins/instance/load-with-profile';
import LoadingMixin from 'web-client/models/core/mixins/instance/loading';
import RollbackMixin from 'web-client/models/core/mixins/instance/rollback';
import SavingMixin from 'web-client/models/core/mixins/instance/saving';
import CachedMixin from 'web-client/models/core/mixins/static/cached';

/**
 * Base class constructed by resource mixins to represent models
 * @class
 */
let Model = EmberObject.extend(
  LoadingMixin,
  SavingMixin,
  ExpiringMixin,
  LoadWithProfileMixin,
  RollbackMixin, {});
Model.reopenClass(CachedMixin, {});

export default Model;
