/* globals _ */

/**
 * Caches instances of resources for retrieval by object key
 * @class
 */
import EmberObject from 'ember-object';

export default EmberObject.extend({
  setResource: function (objKey, modelInstance) {
    this.set(this._stringKey(objKey), modelInstance);
  },
  getResource: function (objKey) {
    return this.get(this._stringKey(objKey));
  },
  _cache: {},
  _stringKey: function (objKey) {
    // Simply calling JSON.stringify on the object is not deterministic due to key ordering.
    return JSON.stringify(_.sortBy(_.pairs(objKey), function (o) { return o[0]; }));
  }
});
