import Serializer from 'web-client/models/core/serializers/serializer';


/**
 * Serializes and deserializes Kraken list API responses
 * @class
 */
export default Serializer.extend({

  /** Configuration */

  totalProperty: '_total',
  collectionProperty: 'objects',
  itemProperty: null,

  /** Publicly exposed properties and methods */

  deserialize: function (response) {
    return {
      total: response[this.get('totalProperty')],
      items: response[this.get('collectionProperty')].map(function (item) {
        return this.get('itemProperty') ? item[this.get('itemProperty')] : item;
      }.bind(this))
    };
  }
});
