/*
  Database schema:

  id                    bigserial         PRIMARY KEY,
  creator_id            integer           NOT NULL,
  start_time_utc        timestamp         NOT NULL,
  end_time_utc          timestamp         NOT NULL,
  time_zone_utc_offset  interval          DEFAULT '0' NOT NULL,
  title                 varchar(255)      NOT NULL,
  game_id               integer           NOT NULL,
  description           text,
  status                events_status     DEFAULT 'available' NOT NULL,
  CREATE TYPE events_status AS ENUM ('available', 'admin_deleted', 'creator_deleted');

  created_at            timestamp         DEFAULT current_timestamp NOT NULL,
  updated_at            timestamp,
*/

import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import { belongsTo } from 'ember-data/relationships';
import computed from 'ember-computed';
import moment from 'moment';

export default Model.extend({
  channel: belongsTo(),

  startTime: attr('date'),
  endTime: attr('date'),
  timeZoneId: attr('string'),
  game: belongsTo(),

  title: attr('string'),
  gameId: attr('number'),
  description: attr('string'),
  status: attr('string'),

  formattedStartEndTime: computed('startTime', 'endTime', function() {
    let startTimeMoment = moment(Date(this.get('startTime')));
    let endTimeMoment = moment(Date(this.get('endTime')));

    return `${ startTimeMoment.format('dddd, MMM d, yyyy - H:mm a') } - ${ endTimeMoment.format('H:mm a') }`;
  })
});

export const AVAILABLE = 'available';
export const ADMIN_DELETED = 'admin_deleted';
export const CREATOR_DELETED = 'creator_deleted';
