/* globals i18n */
import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import computed from 'ember-computed';

export default Model.extend({
  aboutUrl: attr('string'),
  active: attr('boolean'),
  anchor: attr('string', { defaultValue: 'panel' }),
  authorEmail: attr('string'),
  authorName: attr('string'),
  clientId: attr('string'),
  config: attr(),
  configUrl: attr('string'),
  description: attr('string'),
  iconUrl: attr('string'),
  installationCount: attr('number', { defaultValue: 0 }),
  name: attr('string'),
  needsConfig: attr('boolean'),
  panelHeight: attr('number', { defaultValue: 300 }),
  screenshotUrls: attr(),
  state: attr('string'),
  summary: attr('string'),
  supportEmail: attr('string'),
  token: attr('string'),
  version: attr('string'),
  viewerUrl: attr('string'),

  anchorLabel: computed('anchor', function () {
    let anchor = this.get('extension.anchor');
    switch (anchor) {
      case 'video_overlay':
        return i18n('overlay');
      case 'panel':
      default:
        return i18n('panel');
    }
  })
});
