import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import computed from 'ember-computed';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';
import { formatDisplayName } from 'web-client/helpers/format-display-name';

const DEFAULT_USER_NAME = 'Unknown User';

export default Model.extend({
  login: attr('string'),
  displayName: attr('string'),
  accountType: attr('string'),
  twitterConnected: attr('boolean'),
  isStaff: attr('boolean'),
  profileImage: attr('string', {
    defaultValue: JTV_USER_PICTURES_404_USER_70X70_URL
  }),

  // This is the value you should always be reading for usernames to render
  prettyName: computed('displayName', 'login', function () {
    let displayName = this.get('displayName');
    let login = this.get('login');
    displayName = formatDisplayName(login, displayName);
    return displayName || login || DEFAULT_USER_NAME;
  })
});
