import Ember from 'ember';
import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import { belongsTo } from 'ember-data/relationships';

const { computed } = Ember;


export default Model.extend({
  friendId: attr('number'),
  friendLogin: attr('string'),
  isPending: attr('boolean'),
  isAccepted: attr('boolean'),
  isStranger: attr('boolean'),
  isRecommended: attr('boolean', { defaultValue: false }),
  nonStrangerReason: attr(),
  user: belongsTo('friends-list-user', { async: true }),

  isRejected: computed('isPending', 'isAccepted', function () {
    return !this.get('isPending') && !this.get('isAccepted');
  })
});
