import computed from 'ember-computed';
import Model from 'ember-data/model';
import attr from 'ember-data/attr';

export default Model.extend({
  login: attr('string'),
  displayName: attr('string'),
  avatar: attr('string'),
  activities: attr(),
  availability: attr('string'),
  isFriend: attr('boolean', { defaultValue: false }),
  isIdle: computed.equal('availability', 'idle'),
  isOnline: computed.equal('availability', 'online'),
  isOffline: computed.not('isOnline'),
  isRequested: attr('boolean', { defaultValue: false }),
  isRequestedBy: attr('boolean', { defaultValue: false }),
  createdAt: attr('date'),
  recommendedReason: attr('string')
});
