/* globals Twitch */

import computed from 'ember-computed';
import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import moment from 'moment';

export default Model.extend({
  actionDetails: attr(),
  premiumEligibility: attr(),
  product: attr(),
  userEntitlement: attr(),

  gameBoxart: computed('title', function() {
    return Twitch.uri.gameBoxArtJpg(this.get('title'));
  }),

  isForSale: computed('product', 'product.release_end_date', function() {
    let now = moment();
    let end = this.get('product.release_end_date');
    return now.isBefore(end);
  })
});
