/* globals Twitch */

import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import { belongsTo, hasMany } from 'ember-data/relationships';
import computed from 'ember-computed';

export default Model.extend({
  name: attr('string'),
  giantbombId: attr('number'),

  url: computed('id', function () {
    let id = this.get('id');
    return Twitch.uri.game(id);
  }),

  clips: hasMany('clip', { async: true }),
  box: belongsTo('sized-image', {async: false}),
  logo: belongsTo('sized-image', {async: false}),

  // Going forward, let's use the data directly instead of the relationships
  // above. --Mitch Lloyd
  boxImage: attr(),
  logoImage: attr(),

  // Returned by only /top endpoint.
  channelCount: attr('number'),
  viewerCount: attr('number'),

  // returned by featured endpoint,
  featuredOnSidePanel: attr('boolean'),
  featuredOnDirectory: attr('boolean'),
  featuredOnFrontPage: attr('boolean'),
  trackingUrls: attr()
});
