import Video from 'web-client/models/video';
import attr from 'ember-data/attr';
import { belongsTo } from 'ember-data/relationships';
import computed from 'ember-computed';
import { populateNotifications } from 'web-client/models/notification';

const PROCESSED = 'recorded';
const PRIVATE = 'private';

export default Video.extend({
  uploadToken: attr('string'),
  language: attr('string'),
  publishedAt: attr('date'),
  createdAt: attr('date'),
  viewableAt: attr('date'),

  // VOD notifications
  notifications: attr('notifications', {
    defaultValue() {
      return populateNotifications();
    }
  }),

  // An array of thumbnails to choose a preview from
  // Marking this relationship as private to avoid exposing the relationship
  // getter and instead expose a public getter with no side effects.
  _videoUpload: belongsTo('video-upload'),

  isInProgress: computed('status', function() {
    return this.get('status') !== PROCESSED;
  }),

  isProcessed: computed.equal('status', PROCESSED),

  isScheduled: computed('viewable', 'viewableAt', function() {
    return this.get('viewable') === PRIVATE && this.get('viewableAt') !== null;
  }),

  isUnpublished: computed('viewable', 'viewableAt', function() {
    return this.get('viewable') === PRIVATE && this.get('viewableAt') === null;
  }),

  recordedDate: computed('publishedAt', 'createdAt', function() {
    return this.get('publishedAt') ? this.get('publishedAt') : this.get('createdAt');
  }),

  selectedThumbnail: computed('thumbnails', 'thumbnailIndex', function() {
    return this.get('thumbnails')[this.get('thumbnailIndex')];
  }),

  videoUpload: computed('_videoUpload', function() {
    return this.belongsTo('_videoUpload').value();
  }),

  clearThumbnailSelection() {
    this.set('thumbnailIndex', null);
  },

  willDelete() {
    let videoUpload = this.get('videoUpload');

    if (videoUpload) {
      videoUpload.abort();
    }
  }
});
