import Ember from 'ember';
import StoreModel from 'web-client/models/store';
import logApiFailure from 'web-client/utilities/log-api-failure';

const { inject } = Ember;

const MapModel = StoreModel.defineModel({
  deserialize: function (data) {
    data.id = data.map;
    return data;
  }
});

MapModel.defineCollection('all', {
  api: inject.service(),

  request() {
    return this.get('api').request('get', '/api/cs/maps');
  },
  afterSuccess(response) {
    this.setContent(response.maps);
  },
  afterFail() {
    logApiFailure('csgo maps');
  }

});


export default MapModel;
