import get from 'ember-metal/get';
import set from 'ember-metal/set';
import { copy } from 'ember-metal/utils';
import { isPresent } from 'ember-utils';

export const NOTIFICATION_TYPE = Object.freeze({
  CHANNEL_FEED: 'channel_feed',
  EMAIL: 'email'
});

export const NOTIFICATION_VALUES = Object.freeze(Object
  .keys(NOTIFICATION_TYPE)
  .map(key => get(NOTIFICATION_TYPE, key))
);

export function isPublished(type, notifications = {}) {
  const publishDate = notifications && get(notifications, `${type}.sent_at`);
  return isPresent(publishDate);
}

export function canPublish(notifications = {}) {
  return NOTIFICATION_VALUES.some(key => !isPublished(key, notifications));
}

export function populateNotifications(notifications = {}) {
  const clone = copy(notifications, true);

  for (const key in NOTIFICATION_TYPE) {
    const value = get(NOTIFICATION_TYPE, key);

    if (!get(clone, value)) {
      const enabled = value !== NOTIFICATION_TYPE.CHANNEL_FEED;
      set(clone, value, { enabled });
    }
  }
  return clone;
}
