import attr from 'ember-data/attr';
import Model from 'ember-data/model';
import { belongsTo } from 'ember-data/relationships';
import computed from 'ember-computed';
import moment from 'moment';

export default Model.extend({
  offerId: attr('string'),
  priority: attr('number'),
  offerTitle: attr('string'),
  offerDescription: attr('string'),
  publisherName: attr('string'),
  applicableGame: attr('string'),
  contentClaimInstruction: attr('string'),
  contentCategories: attr(''),
  contentDeliveryMethod: attr('string'),
  startTime: attr('date'),
  endTime: attr('date'),
  icon: belongsTo('offer-asset', {async: false}),
  thumbnail: belongsTo('offer-asset', {async: false}),
  detail: belongsTo('offer-asset', {async: false}),

  categories: computed('contentCategories', function(){
    if (this.get('contentCategories')) {
      return this.get('contentCategories').join(' ');
    }
    return '';
  }),
  isLive: computed('startTime', 'endTime', function() {
    let now = moment();
    return moment(this.get('startTime')).isBefore(now) && moment(this.get('endTime')).isAfter(now);
  }).volatile()

});
