import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import computed from 'ember-computed';

export default Model.extend({
  body: attr('string'),
  headline: attr('string'),
  type: attr('string'),
  thumbnailUrl: attr('string'),
  actions: attr(),
  params: attr(),
  createdAt: attr('date-rfc3339'),
  updatedAt: attr('date-rfc3339'),
  read: attr('boolean'),

  actionsMap: computed('actions', function() {
    let actions = this.get('actions');

    let map = {};
    actions.forEach((action) => {
      map[action.type] = {
        body: action.body,
        url: action.url
      };
    });

    return map;
  }),

  primaryCta: computed.readOnly('actionsMap.click')
});
