import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import { hasMany, belongsTo } from 'ember-data/relationships';

export default Model.extend({
  body: attr('string'),
  createdAt: attr('date'),
  deleted: attr('boolean'),
  embeds: attr(),
  emotes: attr(),
  replyPermission: attr('string'),
  reactions: attr(),
  comments: hasMany('comment', {async: false}),
  commentsCursor: attr('string'),
  commentsTotal: attr('number'),
  permissions: attr(),
  user: belongsTo('feed-user', {
    async: false
  })
});
