/* globals _ */

import Ember from 'ember';
import StoreModel from 'web-client/models/store';

const { inject } = Ember;

const RoomPropertiesModel = StoreModel.defineModel({
  api: inject.service(),
  expiration: 60000, // 1 minute

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('id')}/chat_properties`);
  },

  afterSuccess(response) {
    if (response) {
      RoomPropertiesModel.create(_.defaults({
        id: this.get('id')
      }, response));
    }
  }
});

export default RoomPropertiesModel;
