/* globals Twitch */

// TODO: generalize creation of localStorage-backed models
import observer from 'ember-metal/observer';
import StoreModel from 'web-client/models/store';

const defaultChatSettings = {
  showMessageFlags : true,
  showTwitchBotActions: true,
  showModerationActions: true,
  hasSeenFollowersNotification: false,
  lastUsedFollowerDurations: {}
};

// TODO: get DEFAULT_CHAT_COLORS from rails via api
export const COLOR_OPTIONS = ['#FF0000', '#0000FF', '#008000', '#B22222', '#FF7F50', '#9ACD32', '#FF4500',
  '#2E8B57', '#DAA520', '#D2691E', '#5F9EA0', '#1E90FF', '#FF69B4', '#8A2BE2', '#00FF7F'];

export default StoreModel.defineModel({
  colorOptions: COLOR_OPTIONS,

  hidden: true,

  init() {
    this._super(...arguments);

    this.setProperties(Twitch.storage.getObject('chatSettings') || defaultChatSettings);
  },

  setFollowerSelection(channel, value) {
    let existingSelections = this.get('lastUsedFollowerDurations') || {};
    existingSelections[channel] = value;
    this.set('lastUsedFollowerDurations', existingSelections);
    this.autoSave();
  },

  getFollowerSelection(channel) {
    let existingSelections = this.get('lastUsedFollowerDurations') || {};
    return existingSelections[channel];
  },

  autoSave: observer('showModIcons', 'showTimestamps', 'darkMode', 'showMessageFlags', 'showModerationActions', 'showTwitchBotActions', 'lastUsedFollowerDurations', 'hasSeenFollowersNotification', function () {
    let data = this.getProperties('showModIcons', 'showTimestamps', 'darkMode', 'showMessageFlags', 'showModerationActions', 'showTwitchBotActions', 'lastUsedFollowerDurations', 'hasSeenFollowersNotification');
    Twitch.storage.setObject('chatSettings', data);
  })
});
