/* globals Twitch */

import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import computed from 'ember-computed';
import { belongsTo } from 'ember-data/relationships';

export default Model.extend({
  channel: belongsTo('channel'),

  _id: attr('number'),
  averageFps: attr('number'),
  createdAt: attr('date'),
  delay: attr('number'),
  game: attr('string'),
  isPlaylist: attr('boolean'),
  preview: attr(),
  videoHeight: attr('number'),
  viewers: attr('number'),
  isOffline: attr('boolean', { default: false }),

  gameUrl: computed('game', function () {
    return Twitch.uri.game(this.get('game'));
  }),

  gameBoxart: computed('game', function () {
    return Twitch.uri.gameBoxArtJpg(this.get('game'));
  })
});
