import Ember from 'ember';
import StoreModel from 'web-client/models/store';

const { inject } = Ember;

let TicketProductModel = StoreModel.defineModel({
  api: inject.service(),

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('id')}/product`);
  },

  afterSuccess(response) {
    response.ticketProductId = response.name;
    response.id = response.name = this.get('id');
    TicketProductModel.create(response);
  },

  afterFail() {
    // Channel does not have ticket product
  }
});

export default TicketProductModel;
