import computed from 'ember-computed';
import Model from 'ember-data/model';
import attr from 'ember-data/attr';

export default Model.extend({
  lastMessageId: attr('number'),
  lastReadMessageId: attr('number'),

  unreadCount: computed('lastMessageId', 'lastReadMessageId', function () {
    let lastMessageId = this.get('lastMessageId') || 0,
        lastReadId = this.get('lastReadMessageId') || 0;
    return lastMessageId - lastReadId;
  })
});
