import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';
import computed from 'ember-computed';
import { USER_TYPE_STAFF } from 'web-client/utilities/user';

export default Model.extend({
  _id: attr('number'),
  bio: attr('string'),
  displayName: attr('string'),
  email: attr('string'),
  logo: attr('string', { defaultValue: JTV_USER_PICTURES_404_USER_70X70_URL }),
  name: attr('string'),
  notifications: attr(),
  partnered: attr('boolean'),
  type: attr('string'),

  // TODO remove, defensive alias until we remove all 'display_name'
  display_name: computed('displayName', function() {
    console.warn('all usage of user.display_name should be changed to user.displayName');
    return this.get('displayName');
  }),

  staff: computed.equal('type', USER_TYPE_STAFF),

  // temporary hack to match interface of old core models to support {{edit-modal}}
  save(data) {
    if (data) {
      this.setProperties(data);
    }
    return this._super(...arguments);
  }
});
