import StoreModel from 'web-client/models/store';
import VideoManagerProperties from 'web-client/models/video-manager-properties';
import logApiFailure from 'web-client/utilities/log-api-failure';
import injectService from 'ember-service/inject';
import { assign } from 'ember-platform';
import { EXPIRATION_MS } from 'web-client/models/video-manager-properties';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';

let VideoManagerVideo = StoreModel.defineModel({
  api: injectService(),

  expiration: EXPIRATION_MS,

  relationships: {
    /** Important: please read the comment in data/video/video.js re: App.__container__ */
    videoManagerProperties() {
      return VideoManagerProperties.findOne(this.get('channel.name'));
    }
  },

  request() {
    return this.get('api').request('get', `videos/${this.get('id')}`);
  },

  deserialize(data) {
    data.id = data._id;
    data.isRecording = (data.status === 'recording');
    data.highlighterUrl = `/${data.channel.name}/manager/${data.id}/highlight`;
    data.recordedDate = data.published_at || data.created_at;

    return data;
  },

  afterSuccess(response) {
    if (!response) {
      return;
    }

    let properties = assign({}, response);
    properties.id = this.get('id');
    VideoManagerVideo.create(properties);
  },

  saveRemote(data) {
    return this.get('api').request('put', `/api/vods/${this.id.substr(1)}`, data);
  },

  destroyRemote() {
    return this.get('api').request('del', `/kraken/videos/${normalizeVideoId(this.id)}`);
  }
});

VideoManagerVideo.defineCollection('expiringPastBroadcasts', {
  api: injectService(),

  limit: 8,

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('channel')}/video_manager/past_broadcasts`, {
      limit: this.limit,
      offset: this.get('content.length'),
      delete_at: 'expiring'
    });
  },

  afterSuccess(response) {
    this.setContent(response.videos);
  },

  afterFail() {
    logApiFailure('video manager videos');
  }
});

VideoManagerVideo.defineCollection('highlights', {
  api: injectService(),

  limit: 8,

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('channel')}/video_manager/highlights`, {
      limit: this.limit,
      offset: this.get('content.length')
    });
  },

  afterSuccess(response) {
    this.setContent(response.videos);
  },

  afterFail() {
    logApiFailure('video manager videos');
  }
});

VideoManagerVideo.defineCollection('pastBroadcasts', {
  api: injectService(),

  limit: 8,

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('channel')}/video_manager/past_broadcasts`, {
      limit: this.limit,
      offset: this.get('content.length'),
      delete_at: this.get('delete_at')
    });
  },

  afterSuccess(response) {
    this.setContent(response.videos);
  },

  afterFail() {
    logApiFailure('video manager videos');
  }
});

VideoManagerVideo.defineCollection('relatedVideos', {
  api: injectService(),

  limit: 8,

  request() {
    return this.get('api').request('get', `/api/channels/${this.get('channel')}/video_manager/${this.get('id')}/related_videos`, {
      limit: this.limit,
      offset: this.get('content.length')
    });
  },

  afterSuccess(response) {
    this.setContent(response.videos);
  },

  afterFail() {
    logApiFailure('video manager videos');
  }
});


export default VideoManagerVideo;
