import computed from 'ember-computed';
import Model from 'ember-data/model';
import attr from 'ember-data/attr';
import { belongsTo, hasMany } from 'ember-data/relationships';
import { STATE_PRIVATE } from 'web-client/utilities/video/playlist';
import {
  PLAYLIST_PICTURES_404_PLAYLIST_320X180_URL,
  PLAYLIST_PICTURES_404_PLAYLIST_640X360_URL
 } from 'web-client/utilities/urls/static-cdn';

export default Model.extend({
  itemsCount: attr('number'),
  state: attr('string', { defaultValue: STATE_PRIVATE }),
  thumbnailUrl: attr('string', { defaultValue: PLAYLIST_PICTURES_404_PLAYLIST_320X180_URL }),
  title: attr('string'),
  totalDuration: attr('number'),
  updatedAt: attr('string'),
  views: attr('number'),

  /* Relationships Start */
  items: hasMany('video-playlist-item', { async: true }),
  owner: belongsTo('user', { async: true }),
  thumbnail: belongsTo('sized-image', { async: false }),
  /* Relationships End */

  playlistCardImage: computed('thumbnail', 'items.[]', function() {
    let mediumThumbnailUrl = this.get('thumbnail.medium');
    if(mediumThumbnailUrl) {
      return mediumThumbnailUrl;
    }
    return PLAYLIST_PICTURES_404_PLAYLIST_320X180_URL;
  }),
  editorCardUrl: computed('thumbnail', 'items.[]', function() {
    let largeThumbnailUrl = this.get('thumbnail.large');
    if(largeThumbnailUrl) {
      return largeThumbnailUrl;
    }
    return PLAYLIST_PICTURES_404_PLAYLIST_640X360_URL;
  }),
  firstVideoId: computed.alias('items.firstObject.itemId')

});
