import StoreModel from 'web-client/models/store';
import injectService from 'ember-service/inject';
import { EXPIRATION_MS } from 'web-client/models/video-manager-properties';
import { normalizeVideoId } from 'web-client/utilities/normalize-video-id';
import { assign } from 'ember-platform';

let VideoProperties = StoreModel.defineModel({
  api: injectService(),
  expiration: EXPIRATION_MS,

  request() {
    return this.get('api').request('get', `/api/videos/v${normalizeVideoId(this.get('id'))}`);
  },

  afterSuccess(response) {
    if (!response) {
      return;
    }

    let properties = assign({}, response);
    properties.id = this.get('id');
    VideoProperties.create(properties);
  }
});

export default VideoProperties;
