import BasePaginator from './-base';
import injectService from 'ember-service/inject';
import RSVP from 'rsvp';

export default BasePaginator.extend({
  store: injectService(),

  init() {
    this._super(...arguments);
    this.cursor = null;
    this.isComplete = false;
  },

  doQuery() {
    let type = this.relationshipType;
    let store = this.get('store');
    let channel = this.model.get('_id');
    // TODO: Smarter limit for now just bump it up past the default of 9
    let params = { userId: channel, limit: 20 };

    if (this.cursor) {
      params.cursor = this.cursor;
    }

    // If there are no more records to load, just return the same data.
    if (this.isComplete) {
      return RSVP.resolve({
        total: this.total,
        items: []
      });
    }

    return store.query(type, params).then(result => {
      this.set('isComplete', !result.meta.cursor);
      this.set('cursor', result.meta.cursor);

      return {
        total: result.meta.total,
        items: result
      };
    });
  }
});
