import BasePaginator from './-base';
import injectService from 'ember-service/inject';

export default BasePaginator.extend({
  store: injectService(),

  init() {
    this._super(...arguments);
    this.cursor = null;
    this.disabled = null;
    this.topic = null;
    this.isComplete = false;
  },

  doQuery() {
    let type = this.relationshipType;
    let store = this.get('store');
    let id = this.model.get('id');
    let cursor = this.cursor;
    let params = { feed: id };
    if (cursor) {
      params.cursor = cursor;
    }

    return store.query(type, params).then(result => {
      let total = result.meta.total;
      let oldLength = (this.items && this.items.length) || 0;
      let newLength = oldLength + result.get('length');

      this.set('isComplete', newLength >= total);
      this.set('topic', result.meta.topic);
      this.set('disabled', result.meta.disabled);
      this.set('cursor', result.meta.cursor);

      return {
        total,
        items: result
      };
    });
  }
});
