import BasePaginator from './-base';
import injectService from 'ember-service/inject';

export default BasePaginator.extend({
  store: injectService(),

  _getLinkForRelationship(model, relationshipName) {
    // PRIVATE API TODO FIND A BETTER WAY
    // Access to link coming in next version of Ember data
    return model._internalModel._relationships.get(relationshipName).link;
  },

  init() {
    this._super(...arguments);
    this._nextPageURL = this._getLinkForRelationship(this.model, this.relationshipName);
  },

  doQuery() {
    let url = this._nextPageURL;
    let type = this.relationshipType;
    let store = this.get('store');

    return store.query(type, { url }).then(result => {
      this._nextPageURL = result.get('meta.links.next');
      return {
        items: result,
        total: result.meta.total
      };
    });
  }
});
