/* globals i18n, Twitch */

import $ from 'jquery';
import Route from 'ember-route';
import TicketModel from 'web-client/models/ticket';
import injectService from 'ember-service/inject';

export default Route.extend({
  layout: injectService(),
  navigation: injectService(),

  renderTemplate: function () {
    this.render('backpack', {outlet: 'main', controller: 'backpack'});
  },
  activate: function () {
    this.get('navigation').setSelected('Backpack');
    this.set('layout.showRightColumn', false);
    if (!Twitch.user.isLoggedIn()) {
      $.login({mpSourceAction: "page-requires-login"});
    }
  },
  deactivate: function () {
  },
  model: function () {
    return TicketModel.find('user').load();
  },
  buildPageTitle() {
    return {title: i18n('Subscriptions')};
  },
  actions: {
    'handleLoadMoreClick': function () {
      this.controller.loadMore();
    }
  }
});
