import Route from 'ember-route';
import injectService from 'ember-service/inject';
import injectScript from 'web-client/utilities/inject-script';

export default Route.extend({
  globals: injectService(),
  session: injectService(),
  layout: injectService(),

  beforeModel() {
    this._super(...arguments);

    this.set('layout.bypassApplicationLayout', true);
    let jsUrl = this.get('globals.truexJsUrl');
    return injectScript(jsUrl).then(null, () => {
      // return nothing so it continues the transition...
      // the rendered component will handle failed script injection (due to adblock probably)
      return;
    });
  }
});
