import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  collections: injectService(),
  paginator: injectService(),

  beforeModel() {
    this._super(...arguments);

    if (!this.get('collections.isEnabled')) {
      this.replaceWith('channel.index');
    }
  },

  model() {
    let channelName = this.modelFor('user').get('name');
    return this.get('store').findRecord('channel', channelName).then(channelModel => {
      return this.get('paginator').paginatorFor({
        model: channelModel,
        relationshipName: 'collections',
        pageFactory: 'collection'
      });
    });
  }
});
