import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  paginator: injectService(),

  model() {
    let channelName = this.modelFor('user').get('name');

    return this.get('store').findRecord('channel', channelName).then(channelModel => {
      return this.get('paginator').paginatorFor({
        model: channelModel,
        relationshipName: 'following',
        pageFactory: 'follow'
      });
    });
  }
});
