import Route from 'ember-route';
import injectService from 'ember-service/inject';
import VideoTypeMixin from 'web-client/mixins/video-type';
import { SORT_TIME_TYPE } from 'web-client/utilities/video/sorts';

export default Route.extend(VideoTypeMixin, {
  sort: SORT_TIME_TYPE,
  experiments: injectService(),
  showUploadsExperiment: false,

  isInteractive(interactiveComponents) {
    let chatIsInteractive = !this.get('currentModel.show_chat') || interactiveComponents['chat/chat-room-manager'];
    return chatIsInteractive && interactiveComponents['video/recent-uploads'] && interactiveComponents['channel-redesign/videos'];
  },

  model({ videoType }) {
    let channel = this.modelFor('channel').get('id');
    let typedVideo = this._modelForVideoType({
      videoType,
      defaultRoute: 'channel.videos',
      searchParams: { channel },
      videoCollection: 'channel'
    });

    return {
      typedVideo,
      channel
    };
  }
});
