import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  communities: injectService(),
  layout: injectService(),

  isInteractive(interactiveComponents) {
    return interactiveComponents['beacon:no-communities-channels-are-live'] || interactiveComponents['twitch-communities/stream-list-item'];
  },

  activate() {
    this._super(...arguments);
    this.set('layout.showRightColumn', false);
  },

  deactivate() {
    this._super(...arguments);
    this.set('layout.showRightColumn', true);
  },

  model(params) {
    return this.get('communities').getCommunityInfo(params.community_name).then(result => result,
      () => {});
  },

  buildPageTitle() {
    let { name } = this.modelFor(this.routeName);
    let title = name || null;
    return { title };
  }
});
