import Route from 'ember-route';
import injectService from 'ember-service/inject';
import $ from 'jquery';

export default Route.extend({
  communities: injectService(),
  layout: injectService(),
  session: injectService(),

  isInteractive(interactiveComponents) {
    return interactiveComponents['twitch-communities/moderation/moderators/search-result'] ||
      interactiveComponents['beacon:no-edit-permissions'] ||
      interactiveComponents['beacon:no-moderators'];
  },

  activate() {
    this._super(...arguments);
    this.set('layout.showRightColumn', false);
  },

  deactivate() {
    this._super(...arguments);
    this.set('layout.showRightColumn', true);
  },

  beforeModel() {
    this._super(...arguments);

    if (!this.get('session').isAuthenticated) {
      $.login({ mpSourceAction: 'page-requires-login' });
    }
  },

  model(params) {
    return this.get('communities').getCommunityInfo(params.community_name).then(result => result,
      () => {});
  }
});
