/* globals i18n */

import Route from 'ember-route';
import injectService from 'ember-service/inject';
import { styledI18n } from 'web-client/helpers/styled-i18n';
import $ from 'jquery';

export default Route.extend({
  ttLocation: 'dashboard',

  navigation: injectService(),
  session: injectService(),

  model() {
    return this.modelFor('user');
  },

  activate() {
    this.get('navigation').setSelected('Dashboard');

    if (!this.get('session').isAuthenticated) {
      $.login({ mpSourceAction: 'page-requires-login' });
    }
  },

  buildPageTitle() {
    let channel = this.modelFor('user');
    let isInvalidUser = channel.get('notFound') || channel.get('unavailable');
    let title;

    if (isInvalidUser) {
      title = i18n('Dashboards');
    } else {
      title = styledI18n(`%{channelName}'s Dashboard`, { channelName: channel.get('displayName') });
    }

    return { title };
  }
});
