import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  experiments: injectService(),

  beforeModel() {
    this._super(...arguments);

    return this.get('experiments').getExperimentValue('ORC').then(value => {
      if (value !== 'yes') {
        this.transitionTo('404', 'events');
      }
    });
  },

  model() {
    // This is the deprecated channel model. We'll use the id from this
    // model to get the Ember Data model.
    let channelName = this.modelFor('dashboards').get('id');

    // Here we load the Ember Data channel model. By the time we reach
    // this point, the channel has already been loaded into the store
    // so this is a cache hit.
    return this.store.findRecord('channel', channelName);
  }
});
