import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  session: injectService(),

  beforeModel() {
    this._super(...arguments);

    let session = this.get('session');
    let channel = this.modelFor('dashboards');

    let loginName = session.userData.login;
    let isChannelOwner = loginName === channel.id;
    let isStaff = session.userData.is_staff;

    if (!isChannelOwner && !isStaff) {
      this.transitionTo('dashboards.index', loginName);
    }

    if (!channel.get('partner')) {
      this.transitionTo('dashboards.index', loginName);
    }
  },

  model() {
    return this.modelFor('dashboards');
  }
});
