import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  session: injectService(),

  beforeModel() {
    this._super(...arguments);

    let session = this.get('session');
    let user = this.modelFor('user');
    let loginName = session.userData.login;
    let isChannelOwner = loginName === user.id;

    if (!isChannelOwner) {
      this.transitionTo('dashboards.index', loginName);
    }
  },

  model() {
    return this.modelFor('user');
  }
});
