import Route from 'ember-route';
import injectService from 'ember-service/inject';
import RequireProductBeforeModelMixin from 'web-client/mixins/dashboards/subscription-dash/require-product-before-model';

export default Route.extend(RequireProductBeforeModelMixin, {
  subscriptions: injectService(),

  model() {
    let subscriptions = this.get('subscriptions');
    let user = this.modelFor('user');

    return subscriptions.getBadges({ channelID: user._id });
  },

  afterModel() {
    this._super(...arguments);
    let subscriptions = this.get('subscriptions');
    let user = this.modelFor('user');
    let getTimeoutRequest = subscriptions.getTimeoutStatuses({ channelID: user._id });

    return getTimeoutRequest.then(response => {
      if (this.isDestroyed) { return; }

      this._isTimedOut = !!response.badges_timed_out;
    });
  },

  setupController(controller, model) {
    this._super(controller, model);

    let user = this.modelFor('user');

    controller.set('channelID', user._id);
    controller.set('isTimedOut', !!this._isTimedOut);
  }
});
