import Route from 'ember-route';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';

export default Route.extend({
  badges: injectService(),
  bits: injectService(),
  _minBits: null,
  _minBitsEmote: null,
  _amendmentSigned: null,
  _bitsOnboarded: null,
  _requiresServicesTax: null,
  _pinRecentCheers: null,
  _recentCheerMin: null,
  _recentCheerTimeout: null,
  _pinTopCheers: null,

  beforeModel() {
    if (!this._super(...arguments)) { return; }

    let user = this.modelFor('user');
    let channelSettingsPromise = this.get('bits').getChannelSettings(user._id);

    return channelSettingsPromise.then(response => {
      if (this.isDestroyed) { return; }

      this._minBits = response.min_bits;
      this._minBitsEmote = response.min_bits_emote;
      this._amendmentSigned = response.amendment_signed;
      this._bitsOnboarded = response.onboarded;
      this._requiresServicesTax = !response.has_services_record;
      this._pinRecentCheers = response.pin_recent_cheers;
      this._recentCheerMin = response.recent_cheer_min;
      this._recentCheerTimeout = response.recent_cheer_timeout;
      this._pinTopCheers = response.pin_top_cheers;
    });
  },

  model() {
    let user = this.modelFor('user');

    return RSVP.hash({
      product: this.store.findRecord('product', this.modelFor('dashboards').id),
      bitsBadges: this.get('badges').requestGlobalBadges('1'),
      bitsBadgeTiers: this.get('bits').getBadgeTiers(user._id),
      minBits: this._minBits,
      minBitsEmote: this._minBitsEmote,
      amendmentSigned: this._amendmentSigned,
      bitsOnboarded: this._bitsOnboarded,
      requiresServicesTax: this._requiresServicesTax,
      pinRecentCheers: this._pinRecentCheers,
      recentCheerMin: this._recentCheerMin,
      recentCheerTimeout: this._recentCheerTimeout,
      pinTopCheers: this._pinTopCheers,
      enableTimeout: this._recentCheerTimeout > 0,
      user: user
    });
  }
});
