import Route from 'ember-route';
import injectService from 'ember-service/inject';
import RequireProductBeforeModelMixin from 'web-client/mixins/dashboards/subscription-dash/require-product-before-model';

export default Route.extend(RequireProductBeforeModelMixin, {
  bits: injectService(),
  bitsTags: injectService(),
  globals: injectService(),

  beforeModel(transition) {
    if (!this._super(...arguments)) { return; }

    let user = this.modelFor('user');
    let bitsTags = this.get('bitsTags');
    let isBitsTagsEnabled = bitsTags.isChannelTagEnabled(user._id);

    if (!isBitsTagsEnabled) {
      transition.abort();
      return this.intermediateTransitionTo('404', {});
    }
  },

  model() {
    let user = this.modelFor('user');
    return this.get('bits').getHashtags(user._id);
  },

  setupController(controller, model) {
    controller.setProperties({
      hashtags: model.hashtags,
      user: this.modelFor('user')
    });

    this._super(controller, model);
  }
});
