import Route from 'ember-route';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';

export default Route.extend({
  bits: injectService(),
  bounties: injectService(),
  _amendmentAccepted: null,
  _requiresServicesTax: null,

  beforeModel(transition) {
    if (!this._super(...arguments)) { return; }

    let user = this.modelFor('user');
    let channelSettingsPromise = this.get('bits').getChannelSettings(user._id);
    let streamlineBountiesInfo = this.get('bounties').getStreamlineBounties(user._id);
    return RSVP.hash({
      channel: channelSettingsPromise,
      bounties: streamlineBountiesInfo
    }).then(({channel, bounties}) => {
      if (this.isDestroyed) { return; }
      this._requiresServicesTax = !channel.has_services_record;
      this._amendmentAccepted = bounties.amendment_accepted;
    }, () => {
      if (this.isDestroyed) { return; }

      transition.abort();

      return this.intermediateTransitionTo('404', {});
    });
  },

  model() {
    let user = this.modelFor('user');

    return RSVP.hash({
      product: this.store.findRecord('product', this.modelFor('dashboards').id),
      amendmentAccepted: this._amendmentAccepted,
      requiresServicesTax: this._requiresServicesTax,
      user: user
    });
  }
});
