import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  session: injectService(),

  activate() {
    this.controllerFor('dashboards').set('activeVideoStatsTab', true);
  },

  deactivate() {
    this.controllerFor('dashboards').set('activeVideoStatsTab', false);
  },

  beforeModel() {
    this._super(...arguments);

    let session = this.get('session');
    if (!session.isAuthenticated) {
      this.transitionTo('dashboards.index', session.userData.login);
    }

    let channelOwner = this.modelFor('dashboards');
    let isChannelOwner = session.userData.login === channelOwner.id;
    let isStaffOrAdmin = session.userData.is_admin || session.userData.is_staff;

    if (!isChannelOwner && !isStaffOrAdmin) {
      this.transitionTo('dashboards.index', session.userData.login);
    }
  }
});
