import Route from 'ember-route';
import DeprecatedVideo from 'web-client/models/deprecated-video';

export default Route.extend({
  model(params) {
    return DeprecatedVideo.findOne(`v${params.video_id}`).load(true);
  },

  afterModel(video) {
    this._super(...arguments);
    let channelOwner = this.modelFor('dashboards');
    if (video.get('channel.name') !== channelOwner.id) {
      this.transitionTo('404');
    }
  }
});
