import Route from 'ember-route';
import injectService from 'ember-service/inject';
import RSVP from 'rsvp';

export default Route.extend({
  session: injectService(),

  model() {
    let video = this.modelFor('dashboards.video-stats.video');
    return RSVP.hash({
      data: this.store.findRecord('video-stats/video-lifetime', video.id),
      owner: this.modelFor('dashboards'),
      video
    });
  }
});
